//  Copyright (c) 2022 Ham Radio Solutions
//
//  CW Hotline case

$fa = 1;
$fs = 0.4;

boxDepth=100;
boxWidth=60;
boxHeight=4;
boxWallThickness=2;
boxRoundness=1.5;

boardThickness=1.6;

USBAccessDiameter=5;

jackOffset=34;
jackDiameter=6;

speedSwitchDiameter=4;
LEDDiameter=3;

SpeakerHoleDiameter=1.5;
SpeakerDiameter=10;

bossHeight=6;
bossOuterDiameter=3.5;
bossInnerDiameter=1;

difference() {

    //  The major dimensions of the box
    translate([boxRoundness, boxRoundness, boxRoundness])
    minkowski() {
        cube([boxWidth - boxRoundness*2, boxDepth - boxRoundness*2, boxHeight - boxRoundness*2]);
        sphere(boxRoundness);
    }

    //  Then we hollow it out
    translate([boxWallThickness,boxWallThickness,boxWallThickness])
        cube([(boxWidth - (boxWallThickness*2)), (boxDepth - (boxWallThickness * 2)), (boxHeight + boxRoundness + 0.1)]);

    //  Then chop off the top
    //translate([boxWidth-boxWallThickness,boxDepth - boxWallThickness,boxHeight-boxWallThickness])
    translate([0, 0, boxHeight-boxWallThickness])
        cube([boxWidth, boxDepth, boxHeight]);
    
}

difference() {
translate([boxWallThickness,boxWallThickness,boxWallThickness])
    cube([(boxWidth - (boxWallThickness*2)), (boxDepth - (boxWallThickness*2)), (boxRoundness*1.5 + 0.1)]);
translate([boxWallThickness*2,boxWallThickness*2,boxWallThickness])
    cube([(boxWidth - (boxWallThickness*4)), (boxDepth - (boxWallThickness*4)), (boxRoundness*1.5 + 0.2)]);
        //  Add the hole for the key/paddles
    translate([(boxWidth / 2)-9, boxDepth - boxWallThickness, (boxWallThickness)])
            rotate([90,0,0])
            cube([18, boxHeight + boxWallThickness, boxWallThickness]);

}
